﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPageExt.master" AutoEventWireup="true" CodeFile="tbipat_summary.aspx.cs" Inherits="tbipat_summary" %>
<%@ MasterType VirtualPath="~/MasterPageExt.master" %>
<%@ Register TagPrefix="ucTBICDS" TagName="Instrument" Src="~/instruments/ucTBICDSInstrument.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="InstrumentSelection" Src="ucInstrumentSelection.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="NoteSelection" Src="ucNoteSelection.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="AssignPathway" Src="ucAssignPathway.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="OutcomeMeasures" Src="ucOutcomeMeasures.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="Plan" Src="ucPlan.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="MedicalHx" Src="ucMedicalHx.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="EventAddInstrument" Src="ucEventAddInstrument.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="EventRemoveInstrument" Src="ucEventRemoveInstrument.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="EventEdit" Src="ucEventEdit.ascx" %>

<%@ Register TagPrefix="ucTBICDS" TagName="Administration" Src="ucAdministration.ascx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cpHeader" runat="Server">
     <!-- Load CSS -->
     <link href="css/bootstrap.min.css" rel="stylesheet" />
     <link href="css/bootstrap.cerulean.min.css" rel="stylesheet" />
     <link href="css/instruments.css" rel="stylesheet" />
    <script type="text/javascript">

        function AriaTxTreeTabButton(tabpanel)
        {
            tabpanel.items.each(
            
                function (tab)
                {
                    //var a = "<a class=\"x-btn x-unselectable x-box-item x-toolbar-item x-btn-default-toolbar-small x-btn-over\" hidefocus=\"on\" unselectable=\"on\" role=\"button\" style=\"right: auto; left: 81px; top: 0px; margin: 0px;\">";
                    //tab.setTitle(a + tab.title + "</a>");

                    tab.setTitle("<span role=\"button\">" + tab.title + "</span>");
                }
            )

        }

        
        function AriaPatSummaryTabButton(tabpanel) {
            tabpanel.items.each(

                function (tab) {
                    tab.setTitle("<span role=\"button\">" + tab.title + "</span>");;
                }
            )

        }
                

        function AriaInstrumentTabButton(tabpanel) {
            tabpanel.items.each(

                function (tab) {
                    tab.setTitle("<span role=\"button\">" + tab.title + "</span>");;
                }
            )

        }

        function AriaTempSaveBtn(el) {
            el.set({
                "role": 'button'
            });
        }

        function AriaCancTempBtn(el) {
            el.set({
                "role": 'button'
            });
        }

        function AriaNoteSaveProgButton(el) {
            el.set({
                "role": 'button'
            });
        }

        function AriaNoteSelOpsButton(el) {
            el.set({
                "role": 'button'
            });
        }

        function AriaNoteCommitButton(el) {
            el.set({
                "role": 'button'
            });
        }

        function AriaEditEventButton(el)
        {
            el.set({
                "role": 'button',
                "aria-label": 'Edit Event'
            });
        }
   
        function AriaAddEventButton(el) {
            el.set({
                "role": 'button',
                "aria-label": 'Add Event'
            });
        }
        function AriaApplyPathwayButton(el) {
            el.set({
                "role": 'button',
                "aria-label": 'Apply Pathway'
            });
        }

        function AriaCSVBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        
        function AriaCommTIUBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        
        function AriaCancTIUBtn(el) {
            el.set({
                "role": 'button'
            });
        }
                
        function AriaImFinishedBtn(el) {
            el.set({
                "role": 'button'
            });
        }
                
        function AriaDelEvtBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        
        function AriaCancEventBtn(el) {
            el.set({
                "role": 'button'
            });
        }
        
        </script>

     <script type="text/javascript">
         //handle event edit menu click
         var menuEditEventClick = function (menu, item) {
             if (item) {
                 if (item.id == "miCancelE") {
                     App.winEditEvent.hide();
                     //App.PnlCenter.body.update(Ext.String.format("Clicked: {0}", item.text)).highlight();  
                 }

                 if (item.id == "miAddIns") {
                     App.winEditEvent.hide();
                     App.direct.PATSUMMARY.OnShowAddEventInstrument();
                 }

                 if (item.id == "miRemIns") {
                     App.winEditEvent.hide();
                     App.direct.PATSUMMARY.OnShowRemoveEventInstrument();
                 }

                 if (item.id == "miEditE") {
                     App.winEditEvent.hide();
                     App.direct.PATSUMMARY.OnShowEventEdt(1);
                 }

                 if (item.id == "miDelE") {
                     App.winEditEvent.hide();
                     App.direct.PATSUMMARY.OnShowEventDel();
                 }
             }
         };
         var valTIUNoteForm = function ()
         {
             if (App.tfEventNote.isValid())
             {
                 App.btnEventNoteSave.setDisabled(false);
             }
             else
             {
                 App.btnEventNoteSave.setDisabled(true);
             }
         };

     </script>
    <script type="text/javascript">
        function AriaInstrumentHxButton(el) {
            el.set({
                "role": 'button',
                "aria-label": 'Instrument History'
            });
        }
   </script>
    <%--<script src="highcharts/highcharts.js"></script>
    <script src="highcharts/modules/exporting.js"></script>--%>
    <style>
        table.tbl-module-report
        {
            border-collapse: collapse;
            width: 100%;
        }

        .tbl-module-report td
        {
            padding: 8px;
            vertical-align: top;
            width: 50%;
            border-top: 1px solid #e6e5e5;
        }

        .tbl-module-report tr td:nth-child(2)
        {
            padding-left: 20px;
        }

        .tr-report-header td
        {
            background-color: #eee;
            font-weight: bold;
        }

        .on-report-container .on-report-hide
        {
            display: none;
        }
    </style>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <ext:Window ID="winEditEvent"
        runat="server"
        Title=""
        Frame="false"
        Border="false"
        Header="false"
        BodyPadding="0"
        BorderSpec="0 0 0 0"
        Width="250"
        Height="150"
        Closable="false"
        Hidden="true"
        IDMode="Static"

        Modal="true"
        Collapsible="false"
        Resizable="false"
        Maximizable="false"
        Draggable="false" 
        XOnEsc="Ext.emptyFn">
         <Items>
            <ext:MenuPanel runat="server" Height="150" Title="" ID="mplEditEvent">
                <Menu ID="mnuEditEvent" runat="server">
                    <Items>
                        <ext:MenuItem Icon="Add" ID="miAddIns" runat="server" Text="Add Instrument(s)">
                          
                        </ext:MenuItem>
                        <ext:MenuItem Icon="Delete" ID="miRemIns" runat="server" Text="Remove Instrument(s)"></ext:MenuItem>
                        <ext:MenuItem Icon="ApplicationEdit" ID="miEditE" runat="server" Text="Edit Title and Date"></ext:MenuItem>
                        <ext:MenuItem Icon="ApplicationDelete" ID="miDelE" runat="server" Text="Delete Event"></ext:MenuItem>
                        <ext:MenuItem Icon="Cancel" ID="miCancelE" runat="server" Text="Cancel"></ext:MenuItem>
                    </Items>
                    <Listeners>
                        <Click Fn="menuEditEventClick"></Click>
                    </Listeners>
                </Menu>

            </ext:MenuPanel>
        </Items>
        <Listeners>
            <Show Handler="Ext.defer(function() {App.miAddIns.focus(true, 100);}, 1)" />
            <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
            <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
            <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        </Listeners>
    </ext:Window>

 <ext:Window ID="winTIUWarning" runat="server"
            Icon="Information" 
            BodyPadding="6" 
            Width="455" 
             Closable="false"
            AutoHeight="true"
            Hidden="true" Title="Commit to TIU"
            IDMode="Static"
            Constrain="true"
            
            Modal="true"
            Collapsible="false"
            Resizable="false"
            Maximizable="false"
            Draggable="false" 
            XOnEsc="Ext.emptyFn">
     <Listeners>
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />

     </Listeners>
    <Items>
                        
    <ext:TextArea ReadOnly="true" LabelAlign="Top" FieldLabel="" 
        ID="taTIUAlert" Text="" Width="430" Height="200"  runat="server">
    </ext:TextArea>
       
    <ext:Button ID="btnCommTIU" runat="server" Text="Commit Note to TIU" Icon="NoteGo" Height="25">
        <Listeners>
            <AfterRender Handler="AriaCommTIUBtn(App.btnCommTIU.getEl());" ></AfterRender>
            <Click Fn="fnCommitNoteToTIU" />
        </Listeners>
    </ext:Button>


    <ext:Label  runat="server" Text="" Width="10"></ext:Label>
    <ext:Button ID="btnCancTIU" runat="server" Text="Cancel" Height="25">
    <Listeners>
        <AfterRender Handler="AriaCancTIUBtn(App.btnCancTIU.getEl());" ></AfterRender>
        <Click Handler="App.winTIUWarning.hide();"></Click>
    </Listeners>    
    </ext:Button>   
           
    </Items>
</ext:Window>

    <ext:Window ID="winDelEvent" runat="server"
            Icon="Information" 
            BodyPadding="6" 
            Width="455" 
            Height="200" Closable="false"
            AutoHeight="true"
            Hidden="true" Title="Delete Scheduled Event"
            IDMode="Static"
            Constrain="true"
        
            Modal="true"
            Collapsible="false"
            Resizable="false"
            Maximizable="false"
            Draggable="false" 
            XOnEsc="Ext.emptyFn">
        <Listeners>
            <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
            <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
            <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />

        </Listeners>
<Items>
    <ext:Panel ID="pnldelevt" runat="server" MinHeight="200" 
        BodyStyle="text-align: left; margin-top: 10px;" Border="false">
        <Items>
                        
                <ext:TextArea ReadOnly="true" LabelAlign="Top" FieldLabel="" 
                    ID="taDelEvent" Text="Are you sure you want to delete this event from the pathway schedule?" 
                    Width="430" Height="110" runat="server">
                </ext:TextArea>

                <ext:Panel Border="false" Layout="ColumnLayout" runat="server" 
                    Padding="3" Width="850">
                <Items>
                   
                    <ext:Button ID="btnDelEvt" runat="server" Text="Delete Event" Icon="NoteGo">
                        <Listeners>
                            <AfterRender Handler="AriaDelEvtBtn(App.btnDelEvt.getEl());" ></AfterRender>
                        </Listeners>
                    <DirectEvents>
                    <Click OnEvent="OnEventDelete" 
                        Success="App.direct.PATSUMMARY.LoadPatPathwaysList()">
                    </Click>
                    </DirectEvents>
                    </ext:Button>


                    <ext:Label runat="server" Text="" Width="10"></ext:Label>
                    <ext:Button ID="Button2" runat="server" Text="Cancel" Height="25">
                    <Listeners>
                        <AfterRender Handler="AriaCancEventBtn(App.Button2.getEl());" ></AfterRender>
                        <Click Handler="App.winDelEvent.hide();"></Click>
                    </Listeners>    
                    </ext:Button>
                </Items>
                </ext:Panel>
            </Items>
        </ext:Panel>
    </Items>
</ext:Window>

<ext:Window ID="wndTemplateText" 
    Title="Insert Template Text" Hidden="true"
    Layout="AnchorLayout" Height="380" Width="855" 
     IDMode="Static" runat="server" Constrain="true"
   
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Listeners>
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
<Items>    
    <ext:Panel ID="fpnlTemplAdd"
               Margin="0"
               Padding="3"
               Border="false"
               runat="server"
               Visible="true" 
               Layout="AutoLayout" BodyPadding="4">
    <Items>

        <ext:TextArea Padding="2" AutoScroll="true" runat="server" 
            ID="taTemplateText" Height="245" Width="825" FieldLabel="" FieldStyle="font-family: courier new"></ext:TextArea>  

        <ext:RadioGroup
            ID="rgTempl"
            runat="server"
            Vertical="true"
            AnchorHorizontal="99%"
            LabelWidth="50" 
            Padding="3">
            <Items>
            <ext:Radio ID="rdoTemplTop" BoxLabel="Top" LabelWidth="35" Width="90" runat="server" ></ext:Radio>
            <ext:Radio ID="rdoTemplBottom" BoxLabel="Bottom" Checked="true" Width="100"  LabelWidth="50"  runat="server" ></ext:Radio>
            <ext:Radio ID="rdoTemplReplace" BoxLabel="Replace" Width="100" LabelWidth="50"  runat="server" ></ext:Radio>
            </Items>
            <Listeners>
                <Change Handler="App.direct.UCPLAN.OnGroupTypeSelect(this.getValue());" />
            </Listeners>
        </ext:RadioGroup>
    </Items>
    </ext:Panel>
</Items>
<BottomBar>
<ext:Toolbar runat="server">
<Items>
   <ext:Button ID="btnTempSave1" runat="server" Text="OK" Icon="Disk" Handler="App.direct.PATSUMMARY.OnTemplateSave()" >
        <Listeners>
             <AfterRender Handler="AriaTempSaveBtn(App.btnTempSave1.getEl());" ></AfterRender>
        </Listeners>
   </ext:Button>

   <ext:Button ID="btnCancTemp1" runat="server" Text="Cancel" Icon="Cancel" Handler="App.direct.PATSUMMARY.OnTemplateCancel()" >
       <Listeners>
            <AfterRender Handler="AriaCancTempBtn(App.btnCancTemp1.getEl());" ></AfterRender>
       </Listeners>
   </ext:Button>

</Items>
</ext:Toolbar>
</BottomBar>
</ext:Window>

    <ext:Panel ID="pnlMainPatSummary" 
        IDMode="Static" 
        runat="server" 
        AnchorHorizontal="100%" 
        AnchorVertical="100%" 
        Layout="BorderLayout" 
        MarginSpec="10 0 0 0" 
        AutoDoLayout="true" 
        Border="false" 
        Frame="false">
        <HtmlBin>
            <input type="hidden" id="htxtSelectedPatientID" runat="server" />
        </HtmlBin>
        <Items>                     
            <ext:Panel ID="Panel1" runat="server" 
                Region="West" 
                Flex="35" 
                Border="false" 
                Frame="false" 
                Collapsible="true" 
                AutoScroll="false" 
                Split="true" 
                Header="false" 
                Layout="AnchorLayout" >
                <Items>
                    <ext:TabPanel runat="server" 
                        ID="tpTxTree" 
                        IDMode="Static" 
                        Layout="AnchorLayout" 
                        AnchorVertical="100%" 
                        AnchorHorizontal="100%" 
                        AutoScroll="false"
                        Border="false" DefaultType=""
                        Frame="false" 
                        >
                        <Listeners>
                        </Listeners>
                        <Items>
                            
                            <ext:Panel runat="server" 
                                ID = "pnlInstrumentHx" 
                                IDMode="Static" 
                                BodyPadding="2"  
                                Layout="AnchorLayout" 
                                AutoScroll="false"
                                Title="Instrument Hx" 
                                >
                                                              
                                 <Items>
                   
                                    <%-- ########## Instruments DataGrid ########## --%>
                                    <ext:GridPanel ID="gpInstrumentsSummary" 
                                        runat="server"  AutoFocus="true" 
                                        AnchorHorizontal="100%" 
                                        AnchorVertical="100%"  
                                        AutoScroll="true" 
                                        Border="false"
                                        Frame="false" ClientIDMode="Static">
                                        <Store>
                                            <ext:Store ID="storeInstrument" runat="server">
                                                <Fields>
                                                    <ext:ModelField Name="PATIENT_ID" Type="String"></ext:ModelField>
                                                    <ext:ModelField Name="INTAKE_ID" Type="Int"></ext:ModelField>
                                                    <ext:ModelField Name="STATUS" Type="Int"></ext:ModelField>
                                                    <ext:ModelField Name="MID" Type="Int"></ext:ModelField>
                                                    <ext:ModelField Name="MODULE" Type="String"></ext:ModelField>
                                                    <ext:ModelField Name="DATE_COMPLETED" Type="Date"></ext:ModelField>
                                                    <ext:ModelField Name="SCORE" Type="Int"></ext:ModelField>
                                                    <ext:ModelField Name="INTERPRETATION" Type="String"></ext:ModelField>
                                                </Fields>
                                            </ext:Store>
                                        </Store>
                                        <ColumnModel ID="ColumnModel1" runat="server">
                                            <Columns>
                                                <ext:Column runat="server"  DataIndex="MODULE" Header="Instrument" Flex="65">
                                                    <Filter>
                                                        <ext:StringFilter></ext:StringFilter>
                                                    </Filter>
                                                </ext:Column>
                                                <ext:DateColumn runat="server" DataIndex="DATE_COMPLETED" Header="Date" Flex="35">
                                                    <Filter>
                                                        <ext:DateFilter></ext:DateFilter>
                                                    </Filter>
                                                </ext:DateColumn>
                                                <%--<ext:Column ID="Column3" runat="server" DataIndex="SCORE" Header="Score" Flex="1"></ext:Column>
                                                <ext:Column ID="Column4" runat="server" DataIndex="INTERPRETATION" Header="Interpretation" Flex="1"></ext:Column>
                                                <ext:Column ID="Column5" runat="server" DataIndex="STATUS" Header="Completed" Flex="1">
                                                    <Renderer Fn="fnInstrumentCompleted"></Renderer>
                                                </ext:Column>--%>
                                            </Columns>
                                        </ColumnModel>
                                        <Plugins>
                                            <ext:GridFilters runat="server"></ext:GridFilters>
                                        </Plugins>
                                        <SelectionModel>
                                            <ext:RowSelectionModel runat="server" Mode="Single">
                                                <Listeners>
                                                    <Select Handler="fnShowInstrumentRptSummary(record.data.PATIENT_ID, record.data.MID, record.data.INTAKE_ID);"></Select>
                                                </Listeners>
                                                <CustomConfig>
                                                </CustomConfig>
                                            </ext:RowSelectionModel>
                                        </SelectionModel>
                                    </ext:GridPanel>
                                </Items>
                          
                            </ext:Panel>

                            <ext:Panel runat="server" 
                                ID = "pnlVisits" 
                                IDMode = "Static" 
                                BodyPadding="0" 
                                Title = "Schedule" 
                                AnchorVertical = "100%" 
                                AnchorHorizontal = "100%" 
                                AutoScroll="false"
                                Layout="VBoxLayout"
                                OverflowY = "Auto">
                                <LayoutConfig>
                                    <ext:VBoxLayoutConfig Align="Stretch"></ext:VBoxLayoutConfig>
                                </LayoutConfig>
                                <Items>
                                    <ext:TreePanel runat="server"
                                        ID="tTxTree"
                                        IDMode="Static"
                                        Flex="75"
                                        ForceFit="false" 
                                        AutoScroll="true"
                                        DeferRowRender="false"
                                        RootVisible="false"
                                        Border="false"
                                        Frame="false"
                                        MarginSpec="0 0 15 0"
                                        UseArrows="true" 
                                        Lines="false"
                                        HideHeaders="true">
                                        <Store>
                                            <ext:TreeStore ID="TreeStore1" runat="server" AutoLoad="false">
                                                <Root />
                                            </ext:TreeStore>
                                        </Store>
                                        <ColumnModel>
                                            <Columns>
                                                <ext:TreeColumn ID="TreeColumn1" runat="server" Flex="1" DataIndex="text" />
                                            </Columns>
                                        </ColumnModel>
                                        <Listeners>
                                            <BeforeSelect Fn="fnTxTreeBeforeSelect" />
                                            <ItemClick Handler="TxTreeSelectedNode(record, index);"></ItemClick>
                                        </Listeners>
                                        <BottomBar>
                                        <ext:Toolbar ID="tbTreeEvents" runat="server" TabIndex="35" Border="false" >
                                        <Items>
                                            <ext:Button  
                                                ID="btnTreeEvents" runat="server" Text="Edit Event" 
                                                Icon="Pencil" >
                                                  <Listeners>
                                                    <Click Handler="ShowEventCommands( App.tTxTree.getSelectionModel().getSelection()[0] );"></Click>
                                                    <AfterRender Handler="AriaEditEventButton(App.btnTreeEvents.getEl());" >
                                                    </AfterRender>
                                                  </Listeners>
                                            </ext:Button>
                                            <ext:Button  
                                                ID="btnTreeAddEvent" runat="server" Text="Add Event" Icon="Add" >
                                                <Listeners>
                                                    <Click fn="fnAddEvent"></Click>
                                                    <AfterRender Handler="AriaAddEventButton(App.btnTreeAddEvent.getEl());" >
                                                    </AfterRender>
                                                </Listeners>
                                            </ext:Button>
                                            <ext:Button  
                                                ID="btnTreeApplyPW" runat="server" Text="Apply New Pathway" Icon="FolderAdd" >
                                                <Listeners>
                                                    <Click Handler="App.direct.PATSUMMARY.OnShowApplyPathway();"></Click>
                                                    <AfterRender Handler="AriaApplyPathwayButton(App.btnTreeApplyPW.getEl());" >
                                                    </AfterRender>
                                                </Listeners>
                                            </ext:Button>

                                        </Items>
                                        </ext:Toolbar>
                                        </BottomBar>
                                    </ext:TreePanel>


                        <ext:GridPanel
                        ID="gpPathwaysList2"
                        runat="server"
                        AnchorHorizontal="98%"
                        Flex="25"
                        Padding="0" Border="false">
                        <Listeners>
                            <BeforeItemClick Fn="fnSelectPathwayBeforeChange" />
                            <ItemClick Handler="fnSelectPathway( this.store.getAt(index).data, index );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel runat="server" />
                        </SelectionModel>

                        <ColumnModel  runat="server">
                            <Columns>
                                <ext:Column ID="colts12" runat="server" DataIndex="PW_TITLE" Header="Pathways" Flex="8" AutoScroll="true" Wrap="true"></ext:Column>
                                <ext:Column ID="colrs22" runat="server" DataIndex="STATUS" Header="Status" Flex="2" Hidden="true">
                                  <Renderer Fn="fnRenderPWStatus"></Renderer>
                                </ext:Column>
                            </Columns>
                        </ColumnModel>
                        <Store>
                        <ext:Store ID="storePathways2"
                            runat="server"
                            IDMode="Static">
                            <Model>
                                <ext:Model runat="server">
                                    <Fields>
                                        <ext:ModelField Name="PATIENT_ID"></ext:ModelField>
                                        <ext:ModelField Name="CPA_ID"></ext:ModelField>
                                        <ext:ModelField Name="PW_ID"></ext:ModelField>
                                        <ext:ModelField Name="DATE_CREATED"></ext:ModelField>
                                        <ext:ModelField Name="CREATED_BY"></ext:ModelField>
                                        <ext:ModelField Name="STATUS"></ext:ModelField>
                                        <ext:ModelField Name="PW_TYPE_ID"></ext:ModelField>
                                        <ext:ModelField Name="REGION_ID"></ext:ModelField>
                                        <ext:ModelField Name="SITE_ID"></ext:ModelField>
                                        <ext:ModelField Name="PAT_PW_ID"></ext:ModelField>
                                        <ext:ModelField Name="PW_TITLE"></ext:ModelField>
                                        <ext:ModelField Name="PW_DESCR"></ext:ModelField>
                                        <ext:ModelField Name="SELECTED"></ext:ModelField>
                                    </Fields>
                                </ext:Model>
                            </Model>
                        </ext:Store>
                    </Store>
                    </ext:GridPanel>

                                </Items>
                            </ext:Panel>
                        </Items>
                        <Listeners>
                            <TabChange Fn="fnOnLeftPaneTabChanged" />
                        </Listeners>
                    </ext:TabPanel>
                </Items>
            </ext:Panel>
            <ext:Panel
                IDMode="Static"
                ID="EXTCenterPanel"
                Region="Center"
                Split="true"
                Collapsibe="true"
                Header="false"
                Flex="65" 
                Layout="AnchorLayout"
                AutoScroll="false"
                runat="server" 
                Border="false" 
                Frame="false">
                <Items>
                    <ext:TabPanel ID="tpPatientSummary" 
                        runat="server" 
                        Layout="AnchorLayout"  
                        AnchorHorizontal="100%" 
                        AnchorVertical="100%"
                        AutoScroll="false">
                         <Listeners>
                        </Listeners>
                        <Items>
                            
                            <ext:Panel ID="pnlSummaryAdmin"
                                runat="server"
                                Title="Episode"
                                Hidden="true"
                                Anchor="100%"
                                Layout="AnchorLayout"
                                Border="false"
                                Frame="false">
                                <Items>
                                    <ext:Panel ID="pnlSummaryEpisode"
                                        runat="server"
                                        Hidden="true"
                                        AutoScroll="false"
                                        Layout="VBoxLayout"
                                        AnchorHorizontal="100%"
                                        AnchorVertical="100%"
                                        Border="false"
                                        Frame="false">
                                        <LayoutConfig>
                                            <ext:VBoxLayoutConfig Align="Stretch" />
                                        </LayoutConfig>
                                        <Content>
                                            <ucTBICDS:Administration ID="ucAdministration" runat="server" />
                                        </Content>
                                    </ext:Panel>
                                </Items>
                            </ext:Panel>
                            <ext:Panel ID="pnlInstruments" 
                                runat="server"
                                Title="Instruments"
                                Hidden="true"
                                AutoScroll="false" 
                                AnchorHorizontal="100%" 
                                AnchorVertical="100%" 
                                Layout="AnchorLayout" 
                                PaddingSpec="10 5 5 5"
                                Border="false" 
                                Frame="false">    
                                <Items>
                                    <ext:TabPanel runat="server"
                                        ID="pnlInstrumentContainer" 
                                        IDMode="Static"
                                        Hidden="true" 
                                        AnchorHorizontal="100%" 
                                        AnchorVertical="100%" 
                                        Layout="AnchorLayout"
                                        AutoScroll="false">
                                        <Listeners>
                                        </Listeners>
                                        <Items>
                                            <ext:Panel runat="server" 
                                                Title="Report" 
                                                ID="pnlInstrumentReportContainer" 
                                                IDMode="Static"
                                                AnchorHorizontal="100%" 
                                                AnchorVertical="100%" 
                                                Layout="AnchorLayout" 
                                                AutoScroll="true"
                                                Padding="5">
                                                <Items>
                                                    <ext:Panel ID="pnlInstrumentReport" 
                                                        IDMode="Static" 
                                                        runat="server"
                                                        Border="false" 
                                                        Frame="false">
                                                        <TopBar>
                                                            <ext:Toolbar ID="Toolbar2" runat="server">
                                                                <Items>
                                                                    <ext:ToolbarFill />
                                                                    <%--<ext:Button ID="Button1" runat="server" Text="To XML" AutoPostBack="true" OnClick="ToXml" Icon="PageCode" />--%>
                                                                    <%--<ext:Button ID="Button4" runat="server" Text="To Excel" AutoPostBack="true" OnClick="ToExcel" Icon="PageExcel" />--%>
                                                                    <ext:Button ID="Button5" runat="server" Text="To CSV" AutoPostBack="true" OnClick="ToCsv" Icon="PageAttach" >
                                                                    <Listeners>
                                                                        <AfterRender Handler="AriaCSVBtn(App.Button5.getEl());" ></AfterRender>
                                                                    </Listeners>
                                                                    </ext:Button>

                                                                </Items>
                                                            </ext:Toolbar>
                                                        </TopBar>
                                                        <Tpl ID="Tpl1" runat="server">
                                                            <Html>
                                                                <tpl for".">
                                                                    <div class="container-fluid on-report-container">
                                                                        <table width="100%">
                                                                            <tr>
                                                                                <td><h4>{ModuleTitle}</h4></td>
                                                                                <td align="right">{CompletedDate}</td>
                                                                            </tr>
                                                                        </table>
                                                                        <%-- Get instrument's scores --%>
                                                                        <tpl if="Scores.length &gt; 0">
                                                                            <div class="panel panel-default">
                                                                                <div class="panel-heading">Score</div>
                                                                                <div class="panel-body">
                                                                                    <table style="border-collapse: collapse;">
                                                                                        <tr>
                                                                                            <th style="padding-right: 20px;">Description</th>
                                                                                            <th style="width: 80px; padding-right: 20px;">Score</th>
                                                                                            <th>Interpretation</th>
                                                                                        </tr>
                                                                                        <tpl for="Scores">
                                                                                            <tr>
                                                                                                <td style="padding-right: 20px;">{Description}</td>
                                                                                                <td style="padding-right: 20px;">{ScoreValue}</td>
                                                                                                <td>{Interpretation}</td>
                                                                                            </tr>
                                                                                        </tpl>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                        </tpl>

                                                                        <tpl for="Topics">
                                                                            <div class="panel panel-default">
                                                                                <div class="panel-heading">{TopicTitle}</div>
                                                                                <div class="panel-body">
                                                                                    <table class="tbl-module-report">
                                                                                        <tr class="tr-report-header">
                                                                                            <td>Questions</td>
                                                                                            <td>Responses</td>
                                                                                        </tr>
                                                                                        <tpl for="Questions">
                                                                                            <tr>
                                                                                                <td class="td-question">
                                                                                                    {QuestionTitle}
                                                                                                </td>
                                                                                                <td class="td-response">
                                                                                                    <tpl for="Responses">
                                                                                                        <div style="display: block; padding-bottom: 5px;">
                                                                                                            <tpl if="DisplayType == 3">
                                                                                                                <span>{StaticResponseText} {ResponseValue} {ResponseUnit}</span>
                                                                                                            <tpl elseif="DisplayType == 4">
                                                                                                                <tpl if="MID == 4008 || MID == 4004">
                                                                                                                    <span>{StaticResponseText} <span style="font-weight:bold;">{ResponseValue}</span></span>
                                                                                                                <tpl else>
                                                                                                                    <span>{StaticResponseText} {ResponseValue}</span>
                                                                                                                </tpl>
                                                                                                            <tpl elseif="DisplayType == 22">
                                                                                                                <span>{StaticResponseText} {ResponseValue}</span>
                                                                                                            <tpl elseif="DisplayType == 11">
                                                                                                                <span class="hola" style="font-weight:bold;">{ResponseValue}</span>
                                                                                                            <tpl else>
                                                                                                                <span>{ResponseValue}</span>
                                                                                                            </tpl>
                                                                                                        </div>
                                                                                                    </tpl>
                                                                                                </td>
                                                                                            </tr>
                                                                                        </tpl>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                        </tpl>
                                                                    </div>
                                                                </tpl>
                                                            </Html>
                                                        </Tpl>
                                                    </ext:Panel>
                                                </Items>
                                            </ext:Panel>
                                            <ext:Panel runat="server" 
                                                Title="Form" 
                                                ID="pnlInstrumentFormContainer" 
                                                IDMode="Static"
                                                AnchorHorizontal="100%" 
                                                AnchorVertical="100%" 
                                                AutoScroll="false"
                                                Layout="AnchorLayout" 
                                                Padding="5">
                                                <Items>
                                                    <ext:Panel ID="pnlInstrumentEdit"
                                                        IDMode="Static"
                                                        runat="server"
                                                        Border="false"
                                                        Frame="false"
                                                        AutoScroll="true"
                                                        AnchorHorizontal="100%" Padding="2"
                                                        AnchorVertical="100%">
                                                        <Items>
                                                            <ext:Container runat="server" Layout="HBoxLayout" Padding="0">
                                                            <Items>
                                                                <ext:DateField ID="dfAssessmentDate" 
                                                                    runat="server" 
                                                                    FieldLabel="Date/Time" 
                                                                    LabelWidth="65"
                                                                    Width="180" 
                                                                    AllowBlank="false"
                                                                    AutoDataBind="true"
                                                                    MaxDate="<%# DateTime.Today %>"
                                                                    Padding="3"
                                                                    Format="MM/dd/yyyy"
                                                                    Note="MM/DD/YYYY" 
                                                                    NoteAlign="Down"
                                                                    Vtype="date"
                                                                    InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                                                    <Listeners>
                                                                    </Listeners>
                                                                </ext:DateField>

                                                                <ext:TimeField 
                                                                    ID="tfAssessmentTime" 
                                                                    runat="server"
                                                                    Padding="3" Width="100"
                                                                    MinTime="0:00" 
                                                                    MaxTime="23:59" Format="HH:mm" 
                                                                    Increment="1" 
                                                                    Vtype="time2">
                                                                <Listeners>
                                                                </Listeners>
                                                                </ext:TimeField>
                                                            </Items>
                                                            </ext:Container>
                                                        </Items>
                                                        <Content>
                                                            <asp:Panel ID="aspPnlInstrumentContainer" runat="server">
                                                                <ucTBICDS:Instrument ID="ucTBICDSInstrument" runat="server" />
                                                            </asp:Panel>
                                                            <div id="divSaveInstrument" style="text-align: center;">
                                                                <ext:Button ID="btnFinished" IDMode="Static" runat="server" Text="I'm finished!" Icon="Disk">
                                                                    <Listeners>
                                                                        <AfterRender Handler="AriaImFinishedBtn(App.btnFinished.getEl());" ></AfterRender>
                                                                        <Click Fn="fnSubmitInstrument"></Click>
                                                                    </Listeners>
                                                                </ext:Button>
                                                            </div>
                                                            <br />
                                                        </Content>
                                                    </ext:Panel>
                                                </Items>
                                            </ext:Panel>
                                            <ext:Panel runat="server" 
                                                Title="Trend" 
                                                ID="pnlInstrumentTrendContainer" 
                                                IDMode="Static"
                                                Padding="10"
                                                AnchorVertical="100%" 
                                                AnchorHorizontal="100%"
                                                AutoScroll="true">
                                                <Content>
                                                    <div id="divResizer" style="display: block; width: 97%; height: 97%;">
                                                        <div id="divTrendContainer" style="min-width: 600px; min-height: 400px; margin: 0 auto"></div>
                                                    </div>
                                                </Content>
                                            </ext:Panel>
                                        </Items>
                                        <Listeners>
                                            <TabChange Handler="fnInitializeTrendTab"></TabChange>
                                        </Listeners>
                                    </ext:TabPanel>
                                </Items>
                            </ext:Panel>
                            <ext:Panel ID="pnlOutcomes" 
                                runat="server" 
                                Title="Outcomes" 
                                Hidden="true" 
                                BodyPadding="0" 
                                OverflowY="Auto" 
                                Border="false" 
                                Frame="false" 
                                Anchor="100%" 
                                Layout="AnchorLayout">
                                <Content>
                                    <ucTBICDS:OutcomeMeasures ID="ucOutcomeMeasures" runat="server" />
                                </Content>
                            </ext:Panel>
                            <ext:Panel ID="pnlPlan" 
                                runat="server"
                                Title="Assessment / Plan" 
                                Hidden="true" 
                                BodyPadding="0" 
                                OverflowY="Auto" 
                                Border="false" 
                                Frame="false"
                                AnchorHorizontal="100%" 
                                AnchorVertical="100%" 
                                Layout="AnchorLayout">
                                <Content>
                                    <ucTBICDS:Plan ID="ucPlan" runat="server" />
                                </Content>
                            </ext:Panel>
                            <ext:Panel ID="pnlNote"
                                runat="server"
                                Title="Note"
                                BodyPadding="0"
                                OverflowY="Auto"
                                Layout="AnchorLayout"
                                Border="false"
                                Frame="false"
                                Hidden="true">
                                <TopBar>
                                    <ext:Toolbar ID="Toolbar3" runat="server">
                                        <Items>
                                            <ext:Button Padding="3" ID="btnEventNoteSel"
                                                runat="server" Text="Select Note Options" Icon="NoteEdit"
                                                Handler="App.direct.PATSUMMARY.OnShowNoteSelection();">
                                                <Listeners>
                                                    <AfterRender Handler="AriaNoteSelOpsButton(App.btnEventNoteSel.getEl());" ></AfterRender>
                                                </Listeners>
                                            </ext:Button>

                                            <ext:Button ID="btnEventNoteSave" runat="server" Text="Save Note Progress" Icon="Disk">
                                                <Listeners>
                                                    <AfterRender Handler="AriaNoteSaveProgButton(App.btnEventNoteSave.getEl());" ></AfterRender>
                                                    <Click Handler="App.direct.PATSUMMARY.OnEventNoteSave()" />
                                                </Listeners>
                                            </ext:Button>

                                            <ext:Button Icon="NoteGo" ID="btnEventNoteCommit" runat="server" Text="Commit Note to TIU" Height="25">
                                                <Listeners>
                                                    <AfterRender Handler="AriaNoteCommitButton(App.btnEventNoteCommit.getEl());" ></AfterRender>
                                                    <Click Handler="App.direct.PATSUMMARY.OnTIUNoteConfirm()"></Click>
                                                </Listeners>
                                            </ext:Button>

                                        </Items>
                                    </ext:Toolbar>
                                </TopBar>
                                <Items>
                                    <ext:FormPanel runat="server" 
                                        BodyPadding="10" 
                                        Border="false" 
                                        AnchorVertical="100%" 
                                        AnchorHorizontal="100%"
                                        Layout="VBoxLayout">
                                        <LayoutConfig>
                                            <ext:VBoxLayoutConfig Align="Stretch"></ext:VBoxLayoutConfig>
                                        </LayoutConfig>
                                        <Items>
                                            <ext:Container runat="server"
                                                Height="65"
                                                Region="North"
                                                Border="false">
                                                <Items>
                                                    <ext:Hidden runat="server" ID="tfEventNoteLocation"></ext:Hidden>
                                                    <ext:Hidden runat="server" ID="tfEvtNoteConsult"></ext:Hidden>
                                                    <ext:Hidden runat="server" ID="tfEvtNoteCosigner"></ext:Hidden>
                                                    <ext:TextField FieldLabel="Note Title"
                                                        LabelWidth="100"
                                                        AutoDataBind="true"
                                                        ID="tfEventNoteTitle"
                                                        ReadOnly="true"
                                                        Width="600"
                                                        runat="server"/>
                                                    <ext:ComboBox runat="server" 
                                                        ID="cboEventNoteTemplate" 
                                                        FieldLabel="Template"
                                                        Editable="false"
                                                        ValueField="TEMPLATE_ID"
                                                        DisplayField="DESCRIPTION" 
                                                        Width="600">
                                                        <Store>
                                                            <ext:Store ID="storeEventNoteTemplate" AutoLoad="true" runat="server">
                                                                <Model>
                                                                    <ext:Model ID="mdlEventNoteTemplate" runat="server" IDProperty="TEMPLATE_ID">
                                                                        <Fields>
                                                                            <ext:ModelField Name="TEMPLATE_ID" />
                                                                            <ext:ModelField Name="DESCRIPTION" />
                                                                        </Fields>
                                                                    </ext:Model>
                                                                </Model>
                                                                <Reader>
                                                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                                                    </ext:JsonReader>
                                                                </Reader>
                                                            </ext:Store>
                                                        </Store>
                                                        <Listeners>
                                                            <Change Handler="App.direct.PATSUMMARY.LoadNoteTemplate(this.getValue());" />
                                                        </Listeners>
                                                    </ext:ComboBox>
                                                </Items>
                                            </ext:Container>
                                            <ext:Panel runat="server" 
                                                Region="Center" 
                                                Flex="1" 
                                                Border="false" 
                                                AnchorVertical="100%" 
                                                AnchorHorizontal="100%" 
                                                Layout="VBoxLayout">
                                                <LayoutConfig>
                                                    <ext:VBoxLayoutConfig Align="Stretch"></ext:VBoxLayoutConfig>
                                                </LayoutConfig>
                                                <Items>
                                                    <ext:TextArea
                                                        FieldLabel="Note"
                                                        LabelAlign="Top"
                                                        Anchor="100%" 
                                                        Flex="1" 
                                                        Margins="0 0 10 0"
                                                        runat="server"
                                                        ID="tfEventNote"
                                                        Vtype="alphanumXSS"
                                                        FieldStyle="font-family: courier new;">
                                                        <Listeners>
                                                            <Change Fn="valTIUNoteForm" />
                                                        </Listeners>
                                                    </ext:TextArea>
                                                </Items>
                                            </ext:Panel>
                                        </Items>
                                    </ext:FormPanel>
                                </Items>
                            </ext:Panel>
                            <ext:Panel ID="pnlMedicalHx" 
                                runat="server" 
                                Layout="FitLayout"
                                Title="Past Medical History" 
                                Hidden="true" 
                                BodyPadding="0" 
                                OverflowY="Auto" 
                                Border="false" 
                                Frame="false">
                                <Content>
                                    <ucTBICDS:MedicalHx ID="ucMedicalHx" runat="server" />
                                </Content>
                            </ext:Panel>
                            <ext:Panel ID="pnlClear" 
                                runat="server" 
                                Title="Clear" 
                                Hidden="true" 
                                BodyPadding="0" 
                                OverflowY="Auto" 
                                Border="false" 
                                Frame="false" 
                                Layout="FitLayout">
                            </ext:Panel>
                           
                        </Items>
                        <Listeners>
                            <BeforeTabChange Fn="fnTpPatientSummaryBeforeChange" />
                            <TabChange Fn="fnTpPatientSummaryChange" />
                        </Listeners>
                    </ext:TabPanel>
                </Items>
            </ext:Panel>
        </Items>
    </ext:Panel>

   <!-- add instrument-->
   <ucTBICDS:InstrumentSelection ID="ucInstrumentSelection" runat="server" />
   <ucTBICDS:EventAddInstrument ID="ucEventAddInstrument" runat="server" />

   <ucTBICDS:EventRemoveInstrument ID="ucEventRemoveInstrument" runat="server" />
   <ucTBICDS:EventEdit ID="ucEventEdit" runat="server" />

   <!-- TIU note options-->
   <ucTBICDS:NoteSelection ID="ucNoteSelection" runat="server" />

   <!-- Apply pathway-->
   <ucTBICDS:AssignPathway ID="ucAssignPathway" runat="server" />


</asp:Content>


<asp:Content ID="cScripts" runat="server" ContentPlaceHolderID="cpScripts">
    <script src="js/tbipat.summary.js"></script>
    <script src="js/tbipat.summary.views.js"></script>

    <script src="js/jquery.inputmask.min.js"></script>
    <script src="js/jquery.runner.js"></script>
    <script src="js/bootstrap-3.1.1.js"></script>

    <script type="text/javascript" src="js/questions.js"></script>
    <script src="js/questions.mid3000.js"></script>
    <script src="js/questions.mid4000.js"></script>
    <script src="js/questions.mid4001.js"></script>
    <script src="js/questions.mid4002.js"></script>
    <script src="js/questions.mid4004.js"></script>
    <script src="js/questions.mid4008.js"></script>
    <script src="js/questions.mid4014.js"></script>
    <script src="js/questions.mid4026.js"></script>
    <script src="js/questions.mid4040.js"></script>
    <script src="js/questions.mid4044.js"></script>
    <script src="js/questions.mid4048.js"></script>
    <script src="js/questions.mid4050.js"></script>
    <script src="js/questions.mid4052.js"></script>
    <script src="js/questions.mid4062.js"></script>
    <script src="js/questions.mid4068.js"></script>
    <script src="js/questions.mid4072.js"></script>
    <script src="js/questions.mid4074.js"></script>
    <script src="js/questions.mid4078.js"></script>
    <script src="js/questions.mid4082.js"></script>

    <%--<script defer="defer">
        
       

    </script>--%>

</asp:Content>